/*
 * Copyright (c) 2011 and 2012, Dustin Lundquist <dustin@null-ptr.net>
 * Copyright (c) 2011 Manuel Kasper <mk@neon1.net>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
#ifndef RULE_H
#define RULE_H

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <libcork/ds.h>

/*
 * The PCRE2_CODE_UNIT_WIDTH macro must be defined before including pcre2.h.
 * For a program that uses only one code unit width, setting it to 8, 16, or 32
 * makes it possible to use generic function names such as pcre2_compile(). Note
 * that just changing 8 to 16 (for example) is not sufficient to convert this
 * program to process 16-bit characters. Even in a fully 16-bit environment, where
 * string-handling functions such as strcmp() and printf() work with 16-bit
 * characters, the code for handling the table of named substrings will still need
 * to be modified.
 */
/* we only need to support ASCII chartable, thus set it to 8 */
#define PCRE2_CODE_UNIT_WIDTH 8

#include <pcre2.h>

typedef struct rule {
    char *pattern;

    /* Runtime fields */
    pcre2_code *pattern_re;
    pcre2_match_data *pattern_re_match_data;

    struct cork_dllist_item entries;
} rule_t;

void add_rule(struct cork_dllist *, rule_t *);
int init_rule(rule_t *);
rule_t *lookup_rule(const struct cork_dllist *, const char *, size_t);
void remove_rule(rule_t *);
rule_t *new_rule();
int accept_rule_arg(rule_t *, const char *);

#endif
